package gov.va.med.mhv.integration.phr.dao;

import gov.va.med.mhv.integration.phr.stage.transfer.StageEntityAK;

import java.sql.SQLException;
import java.util.List;

public interface PhrCCDADAO extends PhrBaseDAO {

	/**
	 * Delete the CCDA data for the patient.
	 * @param icn the ICN of the patient whose CCDA data should be deleted.
	 * @return The number of records deleted.
	 * @throws SQLException If the delete operation fails.
	 */
	public long deleteCcda(String icn) throws SQLException;

	/**
	 * Load the CCDA document data into the eVault PHR database
	 * @param ak
	 * @param records - Type TBD 
	 * @return
	 * @throws SQLException
	 */
	public int loadCcda(StageEntityAK ak, List<Object> records)
			throws SQLException;

}
